﻿using System;
using System.Collections.Generic;
using System.Text;

namespace IndianHealthService.BMXNet
{
    /// <summary>
    /// This interface is used on an UserControl-based components that are designed to work both inside
    /// the EHR and inside a WinForm application.  The "Consumer" interfaces basically tell Frameworks
    /// that "Consumer" implementating objects need an specific service.  
    /// </summary>
    /// <remarks>
    /// This interface is rarely used but is essential for application needing multiple server-side
    /// jobs. 
    /// </remarks>
    public interface RemoteSessionPoolConsumer
    {
        /// <summary>
        /// This property will be set with the RemoteSessionPool that is used by the Framework.
        /// </summary>  
        /// <remarks>
        /// If you only need one RemoteSession, the most common usage pattern, you do not need the RemoteSessionPoolConsumer
        /// and should use <see cref="RemoteSessionConsumer"/>.
        /// </remarks>
        RemoteSessionPool RemoteSessionPool { set; }
    }
}
